#! /usr/bin/env R

#-----------------------------------------------------------------
library(data.table)
library(haven)
library(lubridate)
import::from(readxl, "read_excel")
#-----------------------------------------------------------------

#-----------------------------------------------------------------
cur_list_active   = c("AUD","BRL","CAD","CHF","CNY","DKK","EUR","GBP","HKD","INR","JPY","KRW",
                     "MXN","MYR","NOK","NZD","SEK","SGD","THB","TWD","ZAR", "LKR")

cur_list_deactive = c("ESP","PTE","ITL","IEP","GRD","DEM","FRF","BEF","ATS")
cur_list          = c(cur_list_active,cur_list_deactive,"USD")

cur_list_reverse  = c("AUD","GBP","EUR","NZD","IEP")

unilat_IN        = as.data.table(read_excel("./input/BBG/AUD.xlsx",skip=2))
names(unilat_IN) = c("date","AUD")
coverage_date    = data.frame(curr="AUD",start=min(unilat_IN$date))
#names(coverage_date) = c("curr","start")

for (currency in cur_list_active[2:length(cur_list_active)]) {
  
  path_readIN    = paste0("./input/BBG/",currency,".xlsx")
  
  FX_temp        = as.data.table(read_excel(path_readIN,skip=2))
  names(FX_temp) = c("date",currency)
 
  
  unilat_IN <- merge(unilat_IN,FX_temp, by.x=c("date"), by.y=c("date"), all = TRUE)
  
  coverage_date = rbind(coverage_date,data.frame(curr=currency, start=min(FX_temp$date)))
} 

for (currency in cur_list_deactive) {
  
  path_readIN    = paste0("./input/BBG/pre_euro/",currency,".xlsx")
  
  FX_temp        = as.data.table(read_excel(path_readIN,skip=2))
  names(FX_temp) = c("date",currency)
  
  
  unilat_IN <- merge(unilat_IN,FX_temp, by.x=c("date"), by.y=c("date"), all = TRUE)
  
  coverage_date = rbind(coverage_date,data.frame(curr=currency, start=min(FX_temp$date)))
} 


unilat_IN[,date := as.integer(date)]

unilat_IN[, AUD := 1/AUD]
unilat_IN[, GBP := 1/GBP]
unilat_IN[, EUR := 1/EUR]
unilat_IN[, NZD := 1/NZD]
unilat_IN[, IEP := 1/IEP]

#==========================================================
#reading the other currencies from Bloomberg

cur_list_Bloomberg = c("SAR","TRY","RUB","QAR","PHP","PLN","PEN","HUF","CZK","EGP","COP","CLP","AED","ILS","IDR","FIM","NLG")

for (currency in cur_list_Bloomberg) {
  
  path_readIN    = paste0("./input/BBG/",currency,"USD.xlsx")
  
  FX_temp        = as.data.table(read_excel(path_readIN))
  names(FX_temp) = c("date",currency)
  print(min(year( FX_temp$date)) )
  print(currency)
  FX_temp        = FX_temp[, date:=year(date)*1e4+month(date)*1e2+mday(date) ]
  
  unilat_IN      = merge(unilat_IN,FX_temp, by.x=c("date"), by.y=c("date"), all = TRUE)
} 

summary(unilat_IN)
#==========================================================


#==========================================================
#fixing 1990-1999 gap for pre Euro currencies: 
FX_preeuro <- as.data.table(read_excel("./input/BBG/BB_preEUR.xlsx"))

setnames(FX_preeuro, "Dates", "date")
setnames(FX_preeuro, c("ATSUSD Curncy",
                       "BEFUSD Curncy",
                       "FRFUSD Curncy",
                       "DEMUSD Curncy",
                       "GRDUSD Curncy",
                       "IEPUSD Curncy",
                       "ITLUSD Curncy",
                       "NLGUSD Curncy",
                       "PTEUSD Curncy",
                       "ESPUSD Curncy"),
         c("ATS",	"BEF", "FRF",	"DEM", "GRD", "IEP",	"ITL", "NLG",	"PTE", "ESP"))

# remove ATS, GRD and PTE because they have too many missings and panel becomes unbalanced:
FX_preeuro <- FX_preeuro[, -c("ATS", "GRD", "PTE")]

# Selecting only 1990-1999 from Bloomberg pre-euro currencies
FX_preeuro <- FX_preeuro[ year(date)>=1990 & year(date)<=1999, -"date" ]

# replace data 
unilat_IN[floor(date/10000)>=1990 & floor(date/10000)<=1999 ,
          c("BEF", "FRF",	"DEM", "IEP",	"ITL", "NLG", "ESP") := FX_preeuro]

summary(unilat_IN)

write.csv(unilat_IN,"./output/FX_daily.csv")
#==========================================================



